/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ChiselRecipe
extends IForgeRegistryEntry.Impl<ChiselRecipe> {
    private final IIngredient<IBlockState> ingredient;
    private final IBlockState stateOut;

    @Nullable
    public static ChiselRecipe get(IBlockState state) {
        return TFCRegistries.CHISEL.getValuesCollection().stream().filter(r -> r.matches(state)).findFirst().orElse(null);
    }

    public ChiselRecipe(Block blockIn, IBlockState stateOut) {
        this((IBlockState state) -> state.func_177230_c() == blockIn, stateOut);
    }

    public ChiselRecipe(IIngredient<IBlockState> ingredient, IBlockState stateOut) {
        this.ingredient = ingredient;
        this.stateOut = stateOut;
    }

    public IBlockState getOutputState() {
        return this.stateOut;
    }

    public boolean matches(IBlockState stateIn) {
        return this.ingredient.test(stateIn);
    }

    public static enum Mode {
        SMOOTH,
        STAIR,
        SLAB;

        private static final Mode[] VALUES;

        @Nonnull
        public static Mode valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : SMOOTH;
        }

        @Nonnull
        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

